/******************************************************************************/
/*																				                                    */
/*	Kroenke, Auer, Vandenberg, and Yoder 					*/
/*	Database Concepts (8th Edition) Chapter 03 	       		*/
/*																				                                    */
/*  Pet-Database Data															                            */
/*																				                                    */
/*	These are the Oracle Express 11gR2 SQL code solutions	                    */
/*																				                                    */
/******************************************************************************/

/*****   PET_OWNER DATA   *****************************************************/

INSERT INTO PET_OWNER VALUES(seqPOID.NextVal, 
    'Downs', 'Marsha', '555-537-8765', 'Marsha.Downs@somewhere.com');
INSERT INTO PET_OWNER VALUES(seqPOID.NextVal, 
    'James', 'Richard', '555-537-7654', 'Richard.James@somewhere.com');
INSERT INTO PET_OWNER VALUES(seqPOID.NextVal, 
    'Frier', 'Liz', '555-537-6543', 'Liz.Frier@somewhere.com');
INSERT INTO PET_OWNER (OwnerID, OwnerLastName, OwnerFirstName, OwnerEmail) VALUES
    (seqPOID.NextVal, 'Trent', 'Miles', 'Miles.Trent@somewhere.com');

COMMIT;

/*****   BREED DATA   ***********************************************************/

INSERT INTO BREED VALUES('Std. Poodle', 22.5, 30.0, 18);
INSERT INTO BREED VALUES('Cashmere', 10.0, 15.0, 12);
INSERT INTO BREED VALUES('Collie Mix', 17.5, 25.0, 18);
INSERT INTO BREED VALUES('Border Collie', 15.0, 22.5, 20);
INSERT INTO BREED(BreedName) VALUES('Unknown');

COMMIT;

/*****   PET DATA   *************************************************************/

INSERT INTO PET VALUES(seqPETID.NextVal,
    'King', 'Dog', 'Std. Poodle', TO_DATE('02/27/14', 'MM/DD/YY'), 1);
INSERT INTO PET VALUES(seqPETID.NextVal,
    'Teddy', 'Cat', 'Cashmere', TO_DATE('02/01/15', 'MM/DD/YY'), 2);
INSERT INTO PET VALUES(seqPETID.NextVal,
    'Fido', 'Dog', 'Std. Poodle', TO_DATE('07/17/13', 'MM/DD/YY'), 1);
INSERT INTO PET VALUES(seqPETID.NextVal,
    'AJ', 'Dog', 'Collie Mix', TO_DATE('05/05/14', 'MM/DD/YY'), 3);
INSERT INTO PET VALUES(seqPETID.NextVal,
    'Cedro', 'Cat', 'Unknown', TO_DATE('06/06/12', 'MM/DD/YY'), 2);
INSERT INTO PET (PetID, PetName, PetType, PetBreed, OwnerID) VALUES(
	seqPETID.NextVal, 'Wooley', 'Cat', 'Unknown', 2);
INSERT INTO PET VALUES(seqPETID.NextVal,
    'Buster', 'Dog', 'Border Collie', TO_DATE('12/11/11', 'MM/DD/YY'), 4);
    
COMMIT;

/*****   PET_3 DATA   ***********************************************************/

INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'King', 'Dog', 'Std. Poodle', TO_DATE('02/27/14', 'MM/DD/YY'), 25.5, 1);
    
INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'Teddy', 'Cat', 'Cashmere', TO_DATE('02/01/15', 'MM/DD/YY'), 10.5, 2);
INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'Fido', 'Dog', 'Std. Poodle', TO_DATE('07/17/13', 'MM/DD/YY'), 28.5, 1);
INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'AJ', 'Dog', 'Collie Mix', TO_DATE('05/05/14', 'MM/DD/YY'), 20.0, 3);
INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'Cedro', 'Cat', 'Unknown', TO_DATE('06/06/12', 'MM/DD/YY'), 9.5, 2);

INSERT INTO PET_3 (PetID, PetName, PetType, PetBreed, PetWeight, OwnerID)
  VALUES(seqPET3ID.NextVal, 'Wooley', 'Cat', 'Unknown', 9.5, 2);

INSERT INTO PET_3 VALUES(seqPET3ID.NextVal,
    'Buster', 'Dog', 'Border Collie', TO_DATE('12/11/11', 'MM/DD/YY'), 25.0, 4);
    
COMMIT;

/****************************************************************************************/